/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.php.internal.parser;

import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class HeredocRule
implements IPredicateRule {
    private IToken token;
    private boolean isNowdoc;
    private int readCount;

    public HeredocRule(IToken token, boolean isNowdoc) {
        this.token = token;
        this.isNowdoc = isNowdoc;
    }

    public IToken getSuccessToken() {
        return this.token;
    }

    public IToken evaluate(ICharacterScanner scanner, boolean resume) {
        if (resume) {
            return Token.UNDEFINED;
        }
        return this.evaluate(scanner);
    }

    /*
     * Unable to fully structure code
     */
    public IToken evaluate(ICharacterScanner scanner) {
        this.readCount = 0;
        if (!this.startsWith(scanner)) ** GOTO lbl9
        identifier = this.readHeredocIdentifier(scanner);
        if (identifier != null && identifier.length() > 0) {
            this.findHeredocClose(scanner, identifier);
        }
        return this.token;
lbl-1000:
        // 1 sources

        {
            scanner.unread();
            --this.readCount;
lbl9:
            // 2 sources

            ** while (this.readCount > 0)
        }
lbl10:
        // 1 sources

        return Token.UNDEFINED;
    }

    private boolean startsWith(ICharacterScanner scanner) {
        int heredocOpenCount = 3;
        while (heredocOpenCount > 0) {
            int character = scanner.read();
            if (character == -1) {
                return false;
            }
            ++this.readCount;
            if (character != 60) {
                return false;
            }
            --heredocOpenCount;
        }
        int character = scanner.read();
        if (character == -1) {
            return false;
        }
        scanner.unread();
        return this.isNowdoc && character == 39 || !this.isNowdoc && (Character.isLetter(character) || character == 34);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String readHeredocIdentifier(ICharacterScanner scanner) {
        int character;
        StringBuilder buffer = new StringBuilder();
        while ((character = scanner.read()) != -1) {
            ++this.readCount;
            if (HeredocRule.isNewLine(scanner, character)) break;
            buffer.append((char)character);
        }
        if (this.isNowdoc) {
            buffer.deleteCharAt(0);
            if (buffer.charAt(buffer.length() - 1) != '\'') return null;
            buffer.deleteCharAt(buffer.length() - 1);
        } else if (buffer.charAt(0) == '\"') {
            buffer.deleteCharAt(0);
            if (buffer.charAt(buffer.length() - 1) != '\"') return null;
            buffer.deleteCharAt(buffer.length() - 1);
        }
        char[] cArray = buffer.toString().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char ch = cArray[n2];
            if (!Character.isLetterOrDigit(ch) && character != 95) {
                return null;
            }
            ++n2;
        }
        return buffer.toString();
    }

    private void findHeredocClose(ICharacterScanner scanner, String identifier) {
        int character;
        StringBuilder buffer = new StringBuilder();
        while ((character = scanner.read()) != -1) {
            ++this.readCount;
            if (HeredocRule.isNewLine(scanner, character)) {
                String line = buffer.toString();
                if (line.equals(identifier) || line.equals(String.valueOf(identifier) + ';')) {
                    scanner.unread();
                    if (line.charAt(line.length() - 1) != ';') break;
                    scanner.unread();
                    break;
                }
                buffer.setLength(0);
                continue;
            }
            buffer.append((char)character);
        }
    }

    private static boolean isNewLine(ICharacterScanner characterScanner, int c) {
        char[][] cArray = characterScanner.getLegalLineDelimiters();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char[] sequence = cArray[n2];
            if (c == sequence[0]) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

